<?php
/*
Plugin Name: GuntherSnaps Elementor Template Shortcodes
Plugin URI: https://gunthersnaps.com/
Description: A custom plugin to create shortcodes from Elementor templates and display them in admin columns with a click-to-copy feature.
Version: 1.2
Author: Gunther Gunderson
Author URI: https://gunthersnaps.com/
License: GPL2
*/

// Prevent direct access to the file
if (!defined('ABSPATH')) {
    exit;
}

// Function to render Elementor template by ID
function render_elementor_template($atts) {
    $atts = shortcode_atts(array(
        'id' => '',
    ), $atts, 'elementor_template');

    if (empty($atts['id'])) {
        return 'No template ID provided.';
    }

    // Check if Elementor is active
    if (!did_action('elementor/loaded')) {
        return 'Elementor is not active.';
    }

    // Load the template
    $template_id = $atts['id'];
    $content = \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($template_id);

    return $content ? $content : 'Template not found or empty.';
}

// Register the shortcode
function register_elementor_template_shortcode() {
    add_shortcode('elementor_template', 'render_elementor_template');
}
add_action('init', 'register_elementor_template_shortcode');

// Enqueue the necessary scripts and styles
function enqueue_gunthersnaps_assets($hook) {
    if (strpos($hook, 'elementor_library') === false && strpos($hook, 'edit.php') === false && strpos($hook, 'post.php') === false) {
        return;
    }
    wp_enqueue_script('gunthersnaps-copy-js', plugin_dir_url(__FILE__) . 'js/gunthersnaps-copy.js', array('jquery'), '1.0', true);
    wp_enqueue_style('gunthersnaps-copy-css', plugin_dir_url(__FILE__) . 'css/gunthersnaps-copy.css', array(), '1.0');
}
add_action('admin_enqueue_scripts', 'enqueue_gunthersnaps_assets');

// Add custom column to posts, pages, and templates
function add_shortcode_column($columns) {
    $columns['gunther_snaps_shortcode'] = __('GuntherSnaps Shortcode', 'gunthersnaps-elementor-template-shortcodes');
    return $columns;
}

// Display the shortcode in the custom column
function display_shortcode_column($column, $post_id) {
    if ($column == 'gunther_snaps_shortcode') {
        // Prevent duplicate rendering
        static $rendered = array();
        if (in_array($post_id, $rendered)) {
            return;
        }
        $rendered[] = $post_id;

        // Display shortcode and copy button
        echo '<div class="gunthersnaps-shortcode-box">';
        echo '<input type="text" class="gunthersnaps-shortcode-input" value="[elementor_template id=\'' . $post_id . '\']" readonly>';
        echo '<button class="gunthersnaps-copy-button">Click to Copy</button>';
        echo '</div>';
    }
}

// Add custom columns to Elementor templates
function add_elementor_custom_columns() {
    add_filter('manage_elementor_library_posts_columns', 'add_shortcode_column');
    add_action('manage_elementor_library_posts_custom_column', 'display_shortcode_column', 10, 2);
}
add_action('admin_init', 'add_elementor_custom_columns');

// Add custom columns to posts and pages
function add_posts_pages_custom_columns() {
    // Add column to posts
    add_filter('manage_posts_columns', 'add_shortcode_column');
    add_action('manage_posts_custom_column', 'display_shortcode_column', 10, 2);

    // Add column to pages
    add_filter('manage_pages_columns', 'add_shortcode_column');
    add_action('manage_pages_custom_column', 'display_shortcode_column', 10, 2);
}
add_action('admin_init', 'add_posts_pages_custom_columns');
?>
